﻿Imports System
Imports System.ComponentModel.Design
Imports System.Globalization
Imports Microsoft.VisualStudio.Shell
Imports Microsoft.VisualStudio.Shell.Interop

''' <summary>
''' Command handler
''' </summary>
Public NotInheritable Class $commandName$

    ''' <summary>
    ''' Command ID.
    ''' </summary>
    Public Const CommandId As Integer = $commandIdValue$

    ''' <summary>
    ''' Command menu group (command set GUID).
    ''' </summary>
    Public Shared ReadOnly CommandSet As New Guid("$cmdSetGuid$")

    ''' <summary>
    ''' VS Package that provides this command, not null.
    ''' </summary>
    Private ReadOnly package As package

    ''' <summary>
    ''' Initializes a new instance of the <see cref="$commandName$"/> class.
    ''' Adds our command handlers for menu (the commands must exist in the command table file)
    ''' </summary>
    ''' <param name="package">Owner package, not null.</param>
    Private Sub New(package As package)
        If package Is Nothing Then
            Throw New ArgumentNullException("package")
        End If

        Me.package = package
        Dim commandService As OleMenuCommandService = Me.ServiceProvider.GetService(GetType(IMenuCommandService))
        If commandService IsNot Nothing Then
            Dim menuCommandId = New CommandID(CommandSet, CommandId)
            // %ifnot% $toolWindow$
            Dim menuCommand = New MenuCommand(AddressOf Me.MenuItemCallback, menuCommandId)
            // %endif%
            // %if% $toolWindow$
            Dim menuCommand = New MenuCommand(AddressOf Me.ShowToolWindow, menuCommandId)
            // %endif%
            commandService.AddCommand(menuCommand)
        End If
    End Sub

    ''' <summary>
    ''' Gets the instance of the command.
    ''' </summary>
    Public Shared Property Instance As $commandName$

    ''' <summary>
    ''' Get service provider from the owner package.
    ''' </summary>
    Private ReadOnly Property ServiceProvider As IServiceProvider
        Get
            Return Me.package
        End Get
    End Property

    ''' <summary>
    ''' Initializes the singleton instance of the command.
    ''' </summary>
    ''' <param name="package">Owner package, Not null.</param>
    Public Shared Sub Initialize(package As package)
        Instance = New $commandName$(package)
    End Sub
    // %ifnot% $toolWindow$

    ''' <summary>
    ''' This function is the callback used to execute the command when the menu item is clicked.
    ''' See the constructor to see how the menu item is associated with this function using
    ''' OleMenuCommandService service and MenuCommand class.
    ''' </summary>
    ''' <param name="sender">Event sender.</param>
    ''' <param name="e">Event args.</param>
    Private Sub MenuItemCallback(sender As Object, e As EventArgs)
        Dim message = String.Format(CultureInfo.CurrentCulture, "Inside {0}.MenuItemCallback()", Me.GetType().FullName)
        Dim title = "$rootItemName$"

        ' Show a message box to prove we were here
        VsShellUtilities.ShowMessageBox(
            Me.ServiceProvider,
            message,
            title,
            OLEMSGICON.OLEMSGICON_INFO,
            OLEMSGBUTTON.OLEMSGBUTTON_OK,
            OLEMSGDEFBUTTON.OLEMSGDEFBUTTON_FIRST)
    End Sub
    // %endif%
    // %if% $toolWindow$

    ''' <summary>
    ''' Shows the tool window when the menu item is clicked.
    ''' </summary>
    ''' <param name="sender">The event sender.</param>
    ''' <param name="e">The event args.</param>
    Private Sub ShowToolWindow(sender As Object, e As EventArgs)

        '' Get the instance number 0 of this tool window. This window Is single instance so this instance
        '' Is actually the only one.
        '' The last flag Is set to true so that if the tool window does Not exists it will be created.
        Dim window As ToolWindowPane = Me.package.FindToolWindow(GetType($toolWindow$), 0, True)
        If window Is Nothing OrElse window.Frame Is Nothing Then
            Throw New NotSupportedException("Cannot create tool window")
        End If

        Dim windowFrame As IVsWindowFrame = window.Frame
        Microsoft.VisualStudio.ErrorHandler.ThrowOnFailure(windowFrame.Show())
    End Sub
    // %endif%
End Class
